<?php
session_start();
require '../../config.php';

if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

$username = $_SESSION['username'];
$query = mysqli_query($conn, "SELECT * FROM admins WHERE username = '$username'");
$admin = mysqli_fetch_assoc($query);

$applications_q = mysqli_query($conn, "SELECT * FROM employee_applications ORDER BY created_at DESC");
?>

<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>All Applications</title>
  <link rel="shortcut icon" type="image/png" href="<?= BASE_URL ?>assets/images/logos/favicon.jpg" />
  <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/styles.min.css" />
  <style>
    .table-avatar {
      width: 50px;
      height: 50px;
      object-fit: cover;
      border-radius: 50%;
    }
    .modal-body img {
      max-width: 150px;
      border-radius: 10px;
      margin-bottom: 15px;
    }

    .modal-body {
        max-height: 70vh;
        overflow-y: auto;
    }
    #modalUploadedDocs img {
        max-width: 120px;
        max-height: 150px;
        object-fit: contain;
        border-radius: 8px;
        border: 1px solid #ddd;
    }
</style>
</head>
<body class="d-flex flex-column min-vh-100">
<div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed"> 

  <?php
    include __DIR__ . '/../partials/header.php';
    include __DIR__ . '/../partials/sidebar.php';
  ?>

  <div class="body-wrapper">
    <div class="body-wrapper-inner container-fluid mt-4">
      <h2 class="mb-4">All Applications</h2>

      <div class="table-responsive">
        <table class="table table-striped table-hover align-middle">
          <thead class="table-dark">
            <tr>
              <th>#</th>
              <th>Full Name</th>
              <th>Email</th>
              <th>Status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php $i = 1; while ($app = mysqli_fetch_assoc($applications_q)): ?>
              <?php
                $full_name = trim(($app['title'] ? $app['title'] . ' ' : '') . $app['first_name'] . ' ' . $app['surname']);
              ?>
              <tr>
                <td><?= $i++ ?></td>
                <td><?= htmlspecialchars($full_name) ?></td>
                <td><?= htmlspecialchars($app['email']) ?></td>
                <td>
                  <?php
                    $status = $app['application_status'];
                    if ($status == 'submitted') {
                      echo '<span class="badge bg-success text-white">Submitted</span>';
                    } elseif ($status == 'in-progress') {
                      echo '<span class="badge bg-warning text-dark">In Progress</span>';
                    } else {
                      echo '<span class="badge bg-secondary">' . htmlspecialchars($status) . '</span>';
                    }
                  ?>
                </td>
                <td>
                  <?php if ($status == 'submitted'): ?>
                    <button 
                      class="btn btn-primary btn-sm view-details-btn" 
                      data-bs-toggle="modal" 
                      data-bs-target="#detailsModal" 
                      data-app='<?= json_encode($app, JSON_HEX_APOS | JSON_HEX_QUOT) ?>'
                    >View</button>
                  <?php else: ?>
                    <span class="text-muted">-</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endwhile; ?>
            <?php if (mysqli_num_rows($applications_q) == 0): ?>
              <tr>
                <td colspan="5" class="text-center">No applications found.</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

    </div>
  </div>

  <?php include __DIR__ . '/../partials/footer.php'; ?>
</div>

<!-- Modal -->
<!-- Modal -->
<div class="modal fade" id="detailsModal" tabindex="-1" aria-labelledby="detailsModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable"> <!-- larger modal -->
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="detailsModalLabel">Application Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body p-4">
        <div class="row">
          <!-- Left side -->
          <div class="col-md-4 border-end">
            <div class="text-center mb-3">
              <img src="" id="modalPassportPhoto" alt="Passport Photo" class="img-thumbnail mb-3" style="max-width: 180px; border-radius: 15px;">
              <h4 id="modalFullName" class="mb-1"></h4>
              <div class="text-muted mb-3">broriser Applicant</div>
            </div>
            <h5>CONTACT</h5>
            <p><strong>Email:</strong> <span id="modalEmail"></span></p>
            <p><strong>Mobile:</strong> <span id="modalMobile"></span></p>
            <p><strong>DOB:</strong> <span id="modalDOB"></span></p>
            <p><strong>Gender:</strong> <span id="modalGender"></span></p>
            <p><strong>NEET:</strong> <span id="modalNeetStatus"></span></p>
            <h5 class="mt-4">IDENTITY</h5>
            <p><strong>Language:</strong> <span id="modalPreferredLanguage"></span></p>
            <p><strong>Nationality:</strong> <span id="modalNationality"></span></p>
            <p><strong>Passport:</strong> <span id="modalHasPassport"></span></p>
            <h5 class="mt-4">ADDRESS</h5>
            <p id="modalAddress"></p>
          </div>

          <!-- Right side -->
          <div class="col-md-8 ps-4">
            <h5>Personal Details</h5>
            <p><strong>Nationality:</strong> <span id="modalNationalityRight"></span></p>
            <p><strong>Country of Birth:</strong> <span id="modalCountryOfBirth"></span></p>
            <p><strong>Language Proficiency:</strong> <span id="modalLanguageProficiency"></span></p>

            <h5 class="mt-4">Academic Qualifications</h5>
            <div id="modalAcademicQualifications"></div>

            <h5 class="mt-4">Statement in Support of Application</h5>
            <p id="modalStatement"></p>

            <h5 class="mt-4">Seat-Booking Payment</h5>
            <p id="modalPaymentInfo"></p>

            <h5 class="mt-4">Uploaded Documents</h5>
            <div id="modalUploadedDocs" class="d-flex flex-wrap gap-3"></div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script src="<?= BASE_URL ?>assets/libs/jquery/dist/jquery.min.js"></script>
<script src="<?= BASE_URL ?>assets/libs/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
<script src="<?= BASE_URL ?>assets/js/sidebarmenu.js"></script>
<script src="<?= BASE_URL ?>assets/js/app.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/iconify-icon@1.0.8/dist/iconify-icon.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
    $('.view-details-btn').on('click', function () {
        const app = $(this).data('app');
        const employeeId = app.id;
        const fullName = [app.title, app.first_name, app.surname].filter(Boolean).join(' ');
        $('#modalFullName').text(fullName);
        $('#modalEmail').text(app.email || 'N/A');
        $('#modalMobile').text(app.mobile || 'N/A');
        $('#modalDOB').text(app.dob || 'N/A');
        $('#modalGender').text(app.gender || 'N/A');

        let neetText = app.marital_status || 'N/A';
        if (app.marital_status === 'Qualified' && app.neet_score) {
            neetText += ' (Score: ' + app.neet_score + ')';
        }
        $('#modalNeetStatus').text(neetText);

        $('#modalPreferredLanguage').text(app.preferred_language || 'N/A');
        $('#modalNationality').text(app.nationality || 'N/A');
        $('#modalHasPassport').text((app.has_passport == 1) ? 'Available' : 'Not Available');

        const addressParts = [app.addr_line1, app.addr_line2, app.city, app.state, app.postal_code, app.country].filter(Boolean);
        $('#modalAddress').html(addressParts.join('<br>') || 'N/A');

        $('#modalNationalityRight').text(app.nationality || 'N/A');
        $('#modalCountryOfBirth').text(app.country_of_birth || 'N/A');
        $('#modalLanguageProficiency').text(app.preferred_language || 'N/A');

        let academicHtml = '<h6>Secondary School Certificate (SSC / 10th)</h6>';
        academicHtml += `<p>
            Year: ${app.ssc_year || 'N/A'}<br>
            School: ${app.ssc_school || 'N/A'}<br>
            Address: ${app.ssc_address || 'N/A'}<br>
            Stream: ${app.ssc_stream || 'N/A'}<br>
            Avg Grade: ${app.ssc_avg_grade || 'N/A'}<br>
            PCB %: ${app.ssc_pcb_percent || 'N/A'}<br>
            Avg %: ${app.ssc_avg_percent || 'N/A'}<br>
            Degree Available: ${app.ssc_degree_available || 'N/A'}<br>
        </p>`;
        academicHtml += '<h6 class="mt-3">Intermediate (Inter / 12th)</h6>';
        academicHtml += `<p>
            Year: ${app.inter_year || 'N/A'}<br>
            School: ${app.inter_school || 'N/A'}<br>
            Address: ${app.inter_address || 'N/A'}<br>
            Stream: ${app.inter_stream || 'N/A'}<br>
            Avg Grade: ${app.inter_avg_grade || 'N/A'}<br>
            PCB %: ${app.inter_pcb_percent || 'N/A'}<br>
            Avg %: ${app.inter_avg_percent || 'N/A'}<br>
            Degree Available: ${app.inter_degree_available || 'N/A'}<br>
        </p>`;

        $('#modalAcademicQualifications').html(academicHtml);

        let statementHtml = app.experience_details ? `<p>${app.experience_details}</p>` : '<p>No statement provided.</p>';
            if (app.experience_letter) {
                const statementFileUrl = `<?= BASE_URL ?>employee/employee-app/uploads/${employeeId}/${app.experience_letter}`;
                statementHtml += `<p><a href="${statementFileUrl}" target="_blank">View Statement File</a></p>`;
            }
            $('#modalStatement').html(statementHtml);

            if (app.payment_proof) {
            const paymentProofUrl = `<?= BASE_URL ?>employee/employee-app/uploads/${employeeId}/${app.payment_proof}`;
            $('#modalPaymentInfo').html(`<a href="${paymentProofUrl}" target="_blank">View Payment Proof</a>`);
        } else {
            $('#modalPaymentInfo').text('No payment info available.');
        }

        const docsContainer = $('#modalUploadedDocs');
        docsContainer.empty();

        if (app.passport_copy) {
            const passportUrl = `<?= BASE_URL ?>employee/employee-app/uploads/${employeeId}/${app.passport_copy}`;
            docsContainer.append(`<div>
                <p><strong>Passport Copy</strong></p>
                <img src="${passportUrl}" alt="Passport Copy" title="Passport Copy">
                </div>`);
        }
            if (app.aadhar_front) {
            const aadharFrontUrl = `<?= BASE_URL ?>employee/employee-app/uploads/${employeeId}/${app.aadhar_front}`;
            docsContainer.append(`<div>
                <p><strong>Aadhar Front</strong></p>
                <img src="${aadharFrontUrl}" alt="Aadhar Front" title="Aadhar Front">
                </div>`);
        }
        if (app.aadhar_back) {
            const aadharBackUrl = `<?= BASE_URL ?>employee/employee-app/uploads/${employeeId}/${app.aadhar_back}`;
            docsContainer.append(`<div>
                <p><strong>Aadhar Back</strong></p>
                <img src="${aadharBackUrl}" alt="Aadhar Back" title="Aadhar Back">
                </div>`);
        }

        const photo = app.passport_photo ? app.passport_photo : 'user-1.jpg';
        const photoPath = `<?= BASE_URL ?>employee/employee-app/uploads/${employeeId}/${photo}`;
        $('#modalPassportPhoto').attr('src', photoPath);

        const status = app.application_status;
        let badge = '';
        if (status === 'submitted') {
            badge = '<span class="badge bg-success">Submitted</span>';
        } else if (status === 'in-progress') {
            badge = '<span class="badge bg-warning text-dark">In Progress</span>';
        } else {
            badge = `<span class="badge bg-secondary">${status}</span>`;
        }
        $('#modalStatus').html(badge);
        });
</script>
</body>
</html>
